#include "stdafx.h"
#define WIN32_LEAN_AND_MEAN
#define FILE_MAX 32

#include <windows.h>
#include <string>

#include "mp3list.h"

using namespace std;

static char* msg_title = "܂FILE vOC - MP3 ꊇϊ";

int WINAPI GetFunctionInfo(char *szMenuString, char *szDevelopString, short* nVersion)
{
	strcpy(szMenuString, "ɂ߂ČlIc[ CDxpeLXg MP3 ꊇϊ\nMP3 ꊇϊ");
	strcpy(szDevelopString, "Copyright (C) 2004 O_tool");

	*nVersion = 1; // 0.01
	return 1;
}

int WINAPI DoProcess(void* pPlugInData)
{
	HANDLE	hMem;
	LPSTR	lpMem;

	string msg = "";
	string fname = "";
	string ftitle = "";
	string fdate = "";
	string s_files[FILE_MAX];
	string d_files[FILE_MAX];
	int	iDisc = 0;

	PLUGIN_DATA_1* pData = (PLUGIN_DATA_1*)pPlugInData;

	for (int iCnt = 0; iCnt < pData->nFileCount; iCnt++) {
		DWORD dwAttr = GetFileAttributes(pData->szFiles[iCnt]);
		if (dwAttr & FILE_ATTRIBUTE_DIRECTORY) {
			continue;
		}
		char* filename = strrchr(pData->szFiles[iCnt], '\\') + 1;
		if ((atoi(filename) != 0) &&
			(filename[2] == '-' || filename[2] == ' ' || filename[2] == '.' || filename[2] == '_')) {
			s_files[atoi(filename)-1] = filename;
		}
	}

	if (OpenClipboard(pData->hMainWnd) == 0) {
		MessageBox(pData->hMainWnd, "OpenClipboard() Error", msg_title,
			MB_OK | MB_ICONSTOP | MB_TASKMODAL);
		return 1;
	}
	if (hMem = GetClipboardData(CF_TEXT)) {
		lpMem = (char*)GlobalLock(hMem);
		if (lpMem == NULL) {
			MessageBox(pData->hMainWnd, "Clipboard Empty", msg_title,
				MB_OK | MB_ICONSTOP | MB_TASKMODAL);
		}
		char *s_pos = lpMem;
		char *l_pos = lpMem + lstrlen(lpMem);
		for (int l_count = 0; ; l_count++) {
			char *pos = s_pos;
			pos = strchr(pos, 0x0D);
			if (pos == NULL) break;
			*pos = '\0';
			if (l_count == 0) {
				fname = s_pos;
			}
			else if (l_count == 1) {
				ftitle = s_pos;
			}
			else if (s_pos[4] == '/' && s_pos[7] == '/') {
				fdate = s_pos;
			}
			else if (memcmp(s_pos, "Disc", 4) == 0) {
				iDisc = atoi(s_pos+4);
			}
			else if ((s_pos[2] == ' ') && (atoi(s_pos) != 0)) {
				d_files[atoi(s_pos)-1] = fname.c_str();
				if (fname.length()) {
					d_files[atoi(s_pos)-1].append(" ");
				}
				d_files[atoi(s_pos)-1].append(s_pos + 3);
				d_files[atoi(s_pos)-1].append(".MP3");
			}
			s_pos = pos + 2;
			if (s_pos >= l_pos) break;
		}
		// for QC
		if (fname.length() == 0 && ftitle.length() == 0) {
			for (int iCount = 0; iCount <FILE_MAX; iCount++) {
				if (s_files[iCount].length()) {
					d_files[iCount] = s_files[iCount].c_str() + 3; 
				}
			}
		}
		GlobalUnlock(hMem);
	}
	CloseClipboard();

	msg.append("Mame = ");
	msg.append(fname.c_str());
	msg.append("\n");

	msg.append("Title = ");
	msg.append(ftitle.c_str());
	msg.append("\n");

	msg.append("Time = ");
	msg.append(fdate.c_str());
	msg.append("\n");
	msg.append("\n");

	for (int iCount = 0; iCount <FILE_MAX; iCount++) {
		if (s_files[iCount].length()) {
			char buf[256];
			wsprintf(buf, "%02d : %s  ->  %s\n", iCount+1, s_files[iCount].c_str(), d_files[iCount].c_str());
			msg.append(buf);
		}
	}
	if (IDCANCEL == MessageBox(pData->hMainWnd, msg.c_str(), msg_title,
			MB_OKCANCEL | MB_ICONEXCLAMATION | MB_DEFBUTTON2 | MB_TASKMODAL)) {
		return 1;
	}
	SetCurrentDirectory(pData->szCurrentPath);
	for (iCount = 0; iCount <FILE_MAX; iCount++) {
		if (s_files[iCount].length()) {
			SYSTEMTIME	st;
			FILETIME ft, local;
			memset(&st, 0, sizeof(st));
			if (fdate.length() >= 10) {
				st.wYear = atoi(fdate.c_str());
				st.wMonth = atoi(fdate.c_str() + 5);
				st.wDay = atoi(fdate.c_str() + 8);
			} else {
				st.wYear = 1980;
				st.wMonth = 1;
				st.wDay = 1;
			}
			if (st.wYear < 1980) {
				st.wYear = 1980;
				st.wMonth = 1;
				st.wDay = 1;
			}
			if (st.wMonth == 0) st.wMonth = 1;
			if (st.wDay == 0) st.wDay = 1;

			st.wHour = ((st.wYear == 1980) &&
				(st.wMonth == 1) && (st.wDay == 1)) ? 9 + iDisc : iDisc;
			st.wMinute = iCount + 1;
			st.wSecond = 0;

			SystemTimeToFileTime(&st, &local);
			LocalFileTimeToFileTime(&local, &ft);

			HANDLE hFile = CreateFile(s_files[iCount].c_str(), GENERIC_WRITE, FILE_SHARE_WRITE,
							NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			if (hFile == INVALID_HANDLE_VALUE) {
				MessageBox(NULL, "CreateFile() error", s_files[iCount].c_str(), MB_OK);
			}
			BOOL flag = SetFileTime(hFile, &ft, &ft, &ft);
			if (flag == FALSE) {
				MessageBox(NULL, "SetFileTime() error", s_files[iCount].c_str(), MB_OK);
			}
			CloseHandle(hFile);
			MoveFile(s_files[iCount].c_str(), d_files[iCount].c_str());
		}
	}
	return 1;
}
